<?php
/*
Plugin Name: حمایت مالی Aran Pal
Plugin URI: https://aranpal.ir
Description: افزونه حمایت مالی از وبسایت ها -- برای استفاده تنها کافی است کد زیر را درون بخشی از برگه یا نوشته خود قرار دهید  [aranPalDonate]
Version: 1.0
Author: Milad Maldar
Author URI: http://miladworkshop.ir
*/

defined('ABSPATH') or die('Access denied!');

define ('aranPalDonateDIR', plugin_dir_path( __FILE__ ));
define ('LIBDIR'  , aranPalDonateDIR.'/lib');
define ('TABLE_DONATE'  , 'aranpal_donate');

require_once ABSPATH . 'wp-admin/includes/upgrade.php';

if ( is_admin() )
{
	add_action('admin_menu', 'ARANPAL_AdminMenuItem');

	function ARANPAL_AdminMenuItem()
	{
		add_menu_page( 'تنظیمات افزونه حمایت مالی - Aran Pal', 'حمات مالی', 'administrator', 'ARANPAL_MenuItem', 'ARANPAL_MainPageHTML', '', 6); 
		add_submenu_page('ARANPAL_MenuItem','نمایش حامیان مالی','نمایش حامیان مالی', 'administrator','aranPalDonations','aranPalDonationsHTML');
	}
}

function ARANPAL_MainPageHTML()
{
	include('aranPalAdmin.php');
}

function aranPalDonationsHTML()
{
	include('aranPalDonations.php');
}


add_action( 'init', 'aranPalDonateShortcode');

function aranPalDonateShortcode(){
	add_shortcode('aranPalDonate', 'aranPalDonateForm');
}

function aranPalDonateForm()
{
	$out 									= '';
	$error 									= '';
	$message 								= '';
  
	$MerchantID 							= get_option( 'ARANPAL_MerchantID');
	$ARANPAL_IsOK 		= get_option( 'ARANPAL_IsOK');
	$ARANPAL_IsError 	= get_option( 'ARANPAL_IsError');
	$ARANPAL_Unit 		= get_option( 'ARANPAL_Unit');
  
	$Amount 								= '';
	$Description 							= '';
	$Name 									= '';
	$Mobile 								= '';
	$Email 									= '';
  
	/////////////////////- START REQUEST -/////////////////////
	if(isset($_POST['submit']) && $_POST['submit'] == 'پرداخت')
	{
		if($MerchantID == '')
		{
			$error = 'کد دروازه پرداخت وارد نشده است' . "<br>\r\n";
		}

		$Amount = filter_input(INPUT_POST, 'ARANPAL_Amount', FILTER_SANITIZE_SPECIAL_CHARS);

		if(is_numeric($Amount) != false)
		{
			if($ARANPAL_Unit == 'ریال')
			$SendAmount =  $Amount / 10;
			else
			$SendAmount =  $Amount;
		} else {
			$error .= 'مبلغ به درستی وارد نشده است' . "<br>\r\n";
		}

		$Description 		= filter_input(INPUT_POST, 'ARANPAL_Description', FILTER_SANITIZE_SPECIAL_CHARS);  // Required
		$Name 				= filter_input(INPUT_POST, 'ARANPAL_Name', FILTER_SANITIZE_SPECIAL_CHARS);  // Required
		$Mobile 			= filter_input(INPUT_POST, 'mobile', FILTER_SANITIZE_SPECIAL_CHARS); // Optional
		$Email 				= filter_input(INPUT_POST, 'email', FILTER_SANITIZE_SPECIAL_CHARS); // Optional
		$SendDescription 	= $Name . ' | ' . $Mobile . ' | ' . $Email . ' | ' . $Description ;  

		if($error == '')
		{
			$CallbackURL 	= ARANPAL_GetCallBackURL();  // Required

			$curl = curl_init();
			curl_setopt($curl, CURLOPT_URL, 'https://aranpal.ir/webservice/rest/PaymentRequest');
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type' => 'application/json'));
			curl_setopt($curl, CURLOPT_POSTFIELDS, "MerchantID={$MerchantID}&Amount={$SendAmount}&InvoiceID={$InvoiceID}&Description={$SendDescription}&Email={$Email}&Mobile={$Mobile}&CallbackURL=". urlencode($CallbackURL));
			curl_setopt($curl, CURLOPT_TIMEOUT, 30);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
			$curl_exec = curl_exec($curl);
			curl_close($curl);

			$result = json_decode($curl_exec);

			if (isset($result->Status) && $result->Status == 100)
			{
				ARANPAL_AddDonate(array(
					'Authority'     => $result->Authority,
					'Name'          => $Name,
					'AmountTomaan'  => $SendAmount,
					'Mobile'        => $Mobile,
					'Email'         => $Email,
					'InputDate'     => current_time( 'mysql' ),
					'Description'   => $Description,
					'Status'        => 'SEND'
				),array(
					'%s',
					'%s',
					'%d',
					'%s',
					'%s',
					'%s',
					'%s',
					'%s'
				));

				return "<script>document.location = '{$result->PaymentUrl}'</script><center>در صورتی که به صورت خودکار به درگاه بانک منتقل نشدید <a href='{$result->PaymentUrl}'>اینجا</a> را کلیک کنید.</center>";
			} else {
				$error .= ARANPAL_GetResaultStatusString($result->Status) . "<br>\r\n";
			}
		}
	}
	////////////////////////- END REQUEST -////////////////////////
  
  
	//////////////////////- START  RESPONSE -//////////////////////
	if (isset($_POST['Authority']) && $_POST['Authority'] != "")
	{
		$Authority = (isset($_POST['Authority']) && $_POST['Authority'] != "") ? $_POST['Authority'] : "";

		if (isset($_POST['PaymentStatus']) && $_POST['PaymentStatus'] == 'OK')
		{
			$Record = ARANPAL_GetDonate($Authority);
	
			if($Record  === false)
			{
				$error .= 'چنین تراکنشی در سایت ثبت نشده است' . "<br>\r\n";
			} else {
				$curl = curl_init();
				curl_setopt($curl, CURLOPT_URL, 'https://aranpal.ir/webservice/rest/PaymentVerification');
				curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type' => 'application/json'));
				curl_setopt($curl, CURLOPT_POSTFIELDS, "MerchantID={$MerchantID}&Amount={$Record['AmountTomaan']}&Authority={$Record['Authority']}");
				curl_setopt($curl, CURLOPT_TIMEOUT, 30);
				curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
				curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
				$curl_exec = curl_exec($curl);
				curl_close($curl);

				$result = json_decode($curl_exec);

				if (isset($result->Status) && $result->Status == 100)
				{					
					ARANPAL_ChangeStatus($Authority, 'OK');
					$message .= get_option( 'ARANPAL_IsOk') . "<br>\r\n";
					$message .= 'کد پیگیری تراکنش:'. $result->RefID . "<br>\r\n";

					$ARANPAL_TotalAmount = get_option("ARANPAL_TotalAmount");
					update_option("ARANPAL_TotalAmount" , $ARANPAL_TotalAmount + $Record['AmountTomaan']);
				} else {
					ARANPAL_ChangeStatus($Authority, 'ERROR');
					$error .= get_option( 'ARANPAL_IsError') . "<br>\r\n";
					$error .= ARANPAL_GetResaultStatusString($result->Status) . "<br>\r\n";
				}
			}
		} else {
			$error .= 'تراکنش توسط کاربر بازگشت خورد';
			ARANPAL_ChangeStatus($Authority, 'CANCEL');
		}
	}
	//////////////////////- END RESPONSE -//////////////////////

	$style = '';

	if(get_option('ARANPAL_UseCustomStyle') == 'true')
	{
		$style = get_option('ARANPAL_CustomStyle');
	} else {
		$style = '#ARANPAL_MainForm {  width: 400px;  height: auto;  margin: 0 auto;  direction: rtl; }  #ARANPAL_Form {  width: 96%;  height: auto;  float: right;  padding: 10px 2%; }  #ARANPAL_Message,#ARANPAL_Error {  width: 90%;  margin-top: 10px;  margin-right: 2%;  float: right;  padding: 5px 2%;  border-right: 2px solid #006704;  background-color: #e7ffc5;  color: #00581f; }  #ARANPAL_Error {  border-right: 2px solid #790000;  background-color: #ffc9c5;  color: #580a00; }  .ARANPAL_FormItem {  width: 90%;  margin-top: 10px;  margin-right: 2%;  float: right;  padding: 5px 2%; }    .ARANPAL_FormLabel {  width: 35%;  float: right;  padding: 3px 0; }  .ARANPAL_ItemInput {  width: 64%;  float: left; }  .ARANPAL_ItemInput input {  width: 90%;  float: right;  border-radius: 3px;  box-shadow: 0 0 2px #00c4ff;  border: 0px solid #c0fff0;  font-family: inherit;  font-size: inherit;  padding: 3px 5px; }  .ARANPAL_ItemInput input:focus {  box-shadow: 0 0 4px #0099d1; }  .ARANPAL_ItemInput input.error {  box-shadow: 0 0 4px #ef0d1e; }  input.ARANPAL_Submit {  background: none repeat scroll 0 0 #2ea2cc;  border-color: #0074a2;  box-shadow: 0 1px 0 rgba(120, 200, 230, 0.5) inset, 0 1px 0 rgba(0, 0, 0, 0.15);  color: #fff;  text-decoration: none;  border-radius: 3px;  border-style: solid;  border-width: 1px;  box-sizing: border-box;  cursor: pointer;  display: inline-block;  font-size: 13px;  line-height: 26px;  margin: 0;  padding: 0 10px 1px;  margin: 10px auto;  width: 50%;  font: inherit;  float: right;  margin-right: 24%; }';
	}

	$out = '
  <style>
    '. $style . '
  </style>
      <div style="clear:both;width:100%;float:right;">
	        <div id="ARANPAL_MainForm">
          <div id="ARANPAL_Form">';
          
if($message != '')
{    
    $out .= "<div id=\"ARANPAL_Message\">
    ${message}
            </div>";
}

if($error != '')
{    
    $out .= "<div id=\"ARANPAL_Error\">
    ${error}
            </div>";
}

     $out .=      '<form method="post">
              <div class="ARANPAL_FormItem">
                <label class="ARANPAL_FormLabel">مبلغ :</label>
                <div class="ARANPAL_ItemInput">
                  <input style="width:60%" type="text" name="ARANPAL_Amount" value="'. $Amount .'" />
                  <span style="margin-right:10px;">'. $ARANPAL_Unit .'</span>
                </div>
              </div>
              
              <div class="ARANPAL_FormItem">
                <label class="ARANPAL_FormLabel">نام و نام خانوادگی :</label>
                <div class="ARANPAL_ItemInput"><input type="text" name="ARANPAL_Name" value="'. $Name .'" /></div>
              </div>
              
              <div class="ARANPAL_FormItem">
                <label class="ARANPAL_FormLabel">تلفن همراه :</label>
                <div class="ARANPAL_ItemInput"><input type="text" name="mobile" value="'. $Mobile .'" /></div>
              </div>
              
              <div class="ARANPAL_FormItem">
                <label class="ARANPAL_FormLabel">ایمیل :</label>
                <div class="ARANPAL_ItemInput"><input type="text" name="email" style="direction:ltr;text-align:left;" value="'. $Email .'" /></div>
              </div>
              
              <div class="ARANPAL_FormItem">
                <label class="ARANPAL_FormLabel">توضیحات :</label>
                <div class="ARANPAL_ItemInput"><input type="text" name="ARANPAL_Description" value="'. $Description .'" /></div>
              </div>
              
              <div class="ARANPAL_FormItem">
                <input type="submit" name="submit" value="پرداخت" class="ARANPAL_Submit" />
              </div>
            </form>
          </div>
        </div>
      </div>
	';

	return $out;
}

register_activation_hook(__FILE__,'aranPalDonate_install');
function aranPalDonate_install()
{
	ARANPAL_CreateDatabaseTables();
}

function ARANPAL_CreateDatabaseTables()
{
		global $wpdb;
		$aranpalDonateTable = $wpdb->prefix . TABLE_DONATE;
		// Creat table
		$nazrezohoor = "CREATE TABLE IF NOT EXISTS `$aranpalDonateTable` (
					  `DonateID` int(11) NOT NULL AUTO_INCREMENT,
					  `Authority` varchar(50) NOT NULL,
					  `Name` varchar(50) CHARACTER SET utf8 COLLATE utf8_persian_ci NOT NULL,
					  `AmountTomaan` int(11) NOT NULL,
					  `Mobile` varchar(11) ,
					  `Email` varchar(50),
					  `InputDate` varchar(20),
					  `Description` varchar(100) CHARACTER SET utf8 COLLATE utf8_persian_ci,
					  `Status` varchar(5),
					  PRIMARY KEY (`DonateID`),
					  KEY `DonateID` (`DonateID`)
					) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;";
		dbDelta($nazrezohoor);
		// Other Options
		add_option("ARANPAL_TotalAmount", 0, '', 'yes');
		add_option("ARANPAL_TotalPayment", 0, '', 'yes');
		add_option("ARANPAL_IsOK", 'با تشکر پرداخت شما به درستی انجام شد.', '', 'yes');
		add_option("ARANPAL_IsError", 'متاسفانه پرداخت انجام نشد.', '', 'yes');
    
    $style = '#ARANPAL_MainForm {
  width: 400px;
  height: auto;
  margin: 0 auto;
  direction: rtl;
}

#ARANPAL_Form {
  width: 96%;
  height: auto;
  float: right;
  padding: 10px 2%;
}

#ARANPAL_Message,#ARANPAL_Error {
  width: 90%;
  margin-top: 10px;
  margin-right: 2%;
  float: right;
  padding: 5px 2%;
  border-right: 2px solid #006704;
  background-color: #e7ffc5;
  color: #00581f;
}

#ARANPAL_Error {
  border-right: 2px solid #790000;
  background-color: #ffc9c5;
  color: #580a00;
}

.ARANPAL_FormItem {
  width: 90%;
  margin-top: 10px;
  margin-right: 2%;
  float: right;
  padding: 5px 2%;
}

.ARANPAL_FormLabel {
  width: 35%;
  float: right;
  padding: 3px 0;
}

.ARANPAL_ItemInput {
  width: 64%;
  float: left;
}

.ARANPAL_ItemInput input {
  width: 90%;
  float: right;
  border-radius: 3px;
  box-shadow: 0 0 2px #00c4ff;
  border: 0px solid #c0fff0;
  font-family: inherit;
  font-size: inherit;
  padding: 3px 5px;
}

.ARANPAL_ItemInput input:focus {
  box-shadow: 0 0 4px #0099d1;
}

.ARANPAL_ItemInput input.error {
  box-shadow: 0 0 4px #ef0d1e;
}

input.ARANPAL_Submit {
  background: none repeat scroll 0 0 #2ea2cc;
  border-color: #0074a2;
  box-shadow: 0 1px 0 rgba(120, 200, 230, 0.5) inset, 0 1px 0 rgba(0, 0, 0, 0.15);
  color: #fff;
  text-decoration: none;
  border-radius: 3px;
  border-style: solid;
  border-width: 1px;
  box-sizing: border-box;
  cursor: pointer;
  display: inline-block;
  font-size: 13px;
  line-height: 26px;
  margin: 0;
  padding: 0 10px 1px;
  margin: 10px auto;
  width: 50%;
  font: inherit;
  float: right;
  margin-right: 24%;
}';
  add_option("ARANPAL_CustomStyle", $style, '', 'yes');
  add_option("ARANPAL_UseCustomStyle", 'false', '', 'yes');
}

function ARANPAL_GetDonate($Authority)
{
	global $wpdb;

	$Authority = strip_tags($wpdb->escape($Authority));

	if($Authority == '')
		return false;

	$aranpalDonateTable = $wpdb->prefix . TABLE_DONATE;

	$res = $wpdb->get_results( "SELECT * FROM ${aranpalDonateTable} WHERE Authority = '${Authority}' LIMIT 1",ARRAY_A);

	if(count($res) == 0)
		return false;

	return $res[0];
}

function ARANPAL_AddDonate($Data, $Format)
{
	global $wpdb;

	if(!is_array($Data))
		return false;

	$aranpalDonateTable = $wpdb->prefix . TABLE_DONATE;

	$res = $wpdb->insert( $aranpalDonateTable , $Data, $Format);

	if($res == 1)
	{
		$totalPay = get_option('ARANPAL_TotalPayment');
		$totalPay += 1;
		update_option('ARANPAL_TotalPayment', $totalPay);
	}

	return $res;
}

function ARANPAL_ChangeStatus($Authority,$Status)
{
	global $wpdb;

	$Authority 	= strip_tags($wpdb->escape($Authority));
	$Status 	= strip_tags($wpdb->escape($Status));

	if($Authority == '' || $Status == '')
		return false;

	$aranpalDonateTable = $wpdb->prefix . TABLE_DONATE;

	$res = $wpdb->query( "UPDATE ${aranpalDonateTable} SET `Status` = '${Status}' WHERE `Authority` = '${Authority}'");

	return $res;
}

function ARANPAL_GetResaultStatusString($StatusNumber)
{
	switch($StatusNumber)
	{
		case -1:
			return 'درخواست باید از طریق متد ارسال شود';
		case -2:
			return 'مقداری برای MerchantID ارسال نشده است';
		case -3:
			return 'مقداری برای Amount ارسال نشده است';
		case -4:
			return 'مقداری برای CallbackURL ارسال نشده است';
		case -5:
			return 'حداقل مبلغ قابل پرداخت 100 تومان می‌باشد';
		case -6:
			return 'MerchantID وارد شده در سیستم یافت نشد';
		case -7:
			return 'MerchantID وارد شده فعال نیست';
		case -8:
			return 'اکانت شما تجاری نیست, لذا امکان استفاده از وبسرویس را ندارید';
		case -9:
			return 'IP معتبر نیست';
		case -10:
			return 'آدرس بازگشتی با آدرس درگاه پرداخت ثبت شده همخوانی ندارد';
		case -11:
			return 'خطای در وب سرویس - ایجاد تراکنش با خطا مواجه شد';
		case -12:
			return 'مقدار Authority ارسالی معتبر نیست - تراکنش یافت نشد';
		case -13:
			return 'مقداری برای Authority ارسال نشده است';
		case -14:
			return 'طلاعات تراکنش یافت نشد, مقدار Authority را برسی کرده و صحیح بودن آن اطمانان حاصل کنید';
		case -15:
			return 'تراکنش پرداخت نشده است';
		case -16:
			return 'مبلغ ارسال شده با مبلغ تراکنش یکسان نیست, مقدار Amount را برسی کرده و نسبت به صحت آن اطمینان حاصل کنید';
		case -17:
			return 'دسترسی شما به این تراکنش رد شد, Authority این تراکنش برای MerchantID شما ثبت نشده است';
		case -18:
			return 'پرداخت تراکنش با موفقیت انجام شده است, اما در بروزرسانی کیف پول پذیرنده مشکلی پیش آمده است';
		case -19:
			return 'وضعیت تراکنش نامشخص است';
		case 100:
			return 'عملیات با موفقیت انجام شد';
		case 101:
			return 'عملیات این تراکنش با موفقیت انجام شد ولی قبلا عملیات اعتبار سنجی بر روی این تراکنش انجام شده است';
	}

	return 'خطای نامشخص';
}

function ARANPAL_GetCallBackURL()
{
	$pageURL 			= (@$_SERVER["HTTPS"] == "on") ? "https://" : "http://";

	$ServerName 		= htmlspecialchars($_SERVER["SERVER_NAME"], ENT_QUOTES, "utf-8");
	$ServerPort 		= htmlspecialchars($_SERVER["SERVER_PORT"], ENT_QUOTES, "utf-8");
	$ServerRequestUri 	= htmlspecialchars($_SERVER["REQUEST_URI"], ENT_QUOTES, "utf-8");

	if ($_SERVER["SERVER_PORT"] != "80")
	{
		$pageURL .= $ServerName .":". $ServerPort . $_SERVER["REQUEST_URI"];
	} else {
		$pageURL .= $ServerName . $ServerRequestUri;
	}

	return $pageURL;
}
?>